/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.api.VWException;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWAdaptor;
import filenet.vw.integrator.adaptors.jms.OASHelper;
import filenet.vw.server.VWCapsule;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class VWJMSAdaptor
implements IVWAdaptor {
    protected QueueSession queueSession = null;
    protected QueueSender queueSender = null;
    protected static final String m_className = "VWJMSAdaptor";
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    private static VWString s_ConnectionSuccessful = new VWString("filenet.vw.integrator.CI.jms.SuccessfulConnection", "Successfully establish sender connection to queue connection factory = {0}, queue={1}");

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String component_descriptor) throws Exception {
        String m_method = "init";
        logger.entering(m_className, m_method);
        VWXMLWrapper component_descriptor_doc = new VWXMLWrapper(component_descriptor);
        Context jndiContext = null;
        String username = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "jaas_username");
        String password = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "jaas_password");
        VWCapsule capsule = new VWCapsule();
        capsule.setString(password);
        password = capsule.getString();
        String queue_cf_name = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "queue_connection_factory");
        String queue_name = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "queue");
        logger.finest(m_className, m_method, username + "," + password + "," + queue_cf_name + "," + queue_name);
        boolean isOASJMS = false;
        try {
            String factory_prop = "java.naming.factory.initial";
            logger.finest(m_className, m_method, "Checking java.naming.factory.initial");
            String CFClass = System.getProperty("java.naming.factory.initial");
            logger.finest(m_className, m_method, "java.naming.factory.initial=" + CFClass);
            boolean bl = isOASJMS = CFClass != null && CFClass.equals("com.evermind.server.ApplicationClientInitialContextFactory");
            if (isOASJMS) {
                if (System.getProperty("filenet.pe.cm.OJMS") == null) {
                    logger.finest(m_className, m_method, "Non OJMS -- checking application client XML");
                    OASHelper.OC4JJMS_create_application_client_XML(queue_cf_name, queue_name);
                }
                Hashtable<String, String> h = new Hashtable<String, String>();
                h.put("java.naming.security.principal", username);
                h.put("java.naming.security.credentials", password);
                logger.finest(m_className, m_method, "loading Initial Context with hashtable");
                jndiContext = new InitialContext(h);
            } else {
                logger.finest(m_className, m_method, "Not OASJMS.");
                String namingProviderURL = System.getProperty("filenet.naming.provider.url");
                jndiContext = VWJMSAdaptor.getNewContext(namingProviderURL);
            }
            logger.finest(m_className, m_method, "Looking up queue connection factory:" + queue_cf_name);
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup(queue_cf_name);
            logger.finest(m_className, m_method, "Looking up queue:" + queue_name);
            Queue queue = (Queue)jndiContext.lookup(queue_name);
            QueueConnection queueConnection = queueConnectionFactory.createQueueConnection(username, password);
            logger.finest(m_className, m_method, "creating queue Session");
            this.queueSession = queueConnection.createQueueSession(false, 1);
            logger.finest(m_className, m_method, "create sender");
            this.queueSender = this.queueSession.createSender(queue);
            logger.info(m_className, m_method, s_ConnectionSuccessful.toString(queue_cf_name, queue_name));
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public void execute(VWStepElement se, String signature) throws Exception {
        logger.entering(m_className, "execute");
        TextMessage message = this.queueSession.createTextMessage();
        StringBuffer sb = new StringBuffer();
        se.toXML(sb);
        message.setText(sb.toString());
        this.queueSender.send((Message)message);
        logger.exiting(m_className, "execute");
    }

    public void stop() throws Exception {
    }

    private static Context getNewContext(String providerURL) throws VWException {
        try {
            String m_method = "getNewContext:" + providerURL;
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (providerURL != null) {
                env.put("java.naming.provider.url", providerURL);
            }
            InitialContext cntx = new InitialContext(env);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, VWJMSAdaptor.getJNDIDebugText(cntx).toString());
            }
            return cntx;
        }
        catch (NamingException ne) {
            throw new VWException(ne);
        }
    }

    private static StringBuffer getJNDIDebugText(Context cntx) {
        StringBuffer txt = new StringBuffer();
        try {
            Hashtable<?, ?> env = cntx.getEnvironment();
            Set<Map.Entry<?, ?>> entries = env.entrySet();
            Iterator<Map.Entry<?, ?>> iter = entries.iterator();
            txt.append("JNDI InitialContext environment");
            while (iter.hasNext()) {
                Map.Entry<?, ?> ent = iter.next();
                txt.append("\n key=");
                txt.append(ent.getKey());
                txt.append(" Value=");
                txt.append(ent.getValue());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return txt;
    }
}

